<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\Payment;

use CpCreation\VitiCore\Cart\Model\Payment\Cawl;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class CawlPaymentType extends AbstractType implements PaymentMethodInterface, DataTransformerInterface
{
    const TYPE = 'cawl';

    private $serializer;

    public function __construct()
    {
        $normalizers = [new ObjectNormalizer()];
        $this->serializer = new Serializer($normalizers);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class,[
                'label' => 'Nom',
                'required'    => true
            ])
            ->add('production', ChoiceType::class, [
                'choices' => [
                    'production' => true,
                    'test' => false,
                ],
                'label'       => 'Production',
                'required'    => true
            ])
            ->add('pspid', TextType::class, [
                'label'       => 'Identifiant (pspid)',
                'required'    => true
            ])
            ->add('apiKey', TextType::class, [
                'label'       => 'Clé API',
                'required'    => true
            ])
            ->add('apiSecret', TextType::class, [
                'label'       => 'Clé secrète',
                'required'    => true
            ])
            ->add('webhookKey', TextType::class, [
                'label' => 'Key du webhook',
                'required'    => true,
            ])
            ->add('webhookSecret', TextType::class, [
                'label' => 'Secret du webhook',
                'required'    => true,
            ])
        ;

        $builder->addModelTransformer($this);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Cawl::class
        ]);
    }

    public function transform($data)
    {

        return $this->serializer->denormalize($data, Cawl::class);
    }

    public function reverseTransform($data)
    {

        return $this->serializer->normalize($data);
    }

    public function getMethod()
    {
        return static::TYPE;
    }

    public function getBlockPrefix()
    {
        return 'cawl_payment';
    }
}