<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Shop\Model\DeliveryMethodCategory;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class DeliveryMethodCategoryType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                    'label'  => false,
                    'fields' => [
                        'name' => [
                            'field_type' => TextType::class,
                            'label'      => 'Nom de la méthode de livraison',
                            'required'   => true,
                        ],
                        'description' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Description de la méthode de livraison',
                            'required'   => false,
                        ],
                        'minViewTextOpen' => [
                            'field_type' => TextType::class,
                            'label'      => 'Texte pour le lien pour déplier l\'ensemble des méthodes de livraison de cette catégorie',
                            'required'   => false,
                        ],
                        'minViewTextClose' => [
                            'field_type' => TextType::class,
                            'label'      => 'Texte pour le lien pour replier l\'ensemble des méthodes de livraison de cette catégorie',
                            'required'   => false,
                        ],

                    ],
                    'excluded_fields' => ['slug']
                ]
            )
            ->add(
                'disabledShippingAddress', CheckboxType::class,
                [
                    'label'    => 'Désactiver l\'adresse de livraison avec cette méthode de livraison',
                    'required' => false,
                ]
            )
            ->add('minView', CheckboxType::class, ['label' => 'Cliquer pour dérouler toute la liste des méthodes dans cette catégorie', 'required' => false])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => DeliveryMethodCategory::class,
            ]
        );
    }
}
