<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\EventListener;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\Routing\RouterInterface;

class VerifyListener implements EventSubscriberInterface
{
    public function __construct(private RouterInterface $router)
    {
        $this->router  = $router;
    }

    public static function getSubscribedEvents()
    {
        return [
            KernelEvents::REQUEST => [['onKernelRequest', 10]],
        ];
    }

    public function onKernelRequest(RequestEvent $event)
    {

        if (preg_match('/baidu|dareboost|bingbot|facebookexternalhit|googlebot|-google|ia_archiver|msnbot|naverbot|pingdom|seznambot|slurp|teoma|twitter|yandex|yeti|speed|insights|woobot|ighth|tmetr|eadle|gtmetrix|lighthouse/i', $_SERVER['HTTP_USER_AGENT'])) {
            return;
        }

        if (!$event->isMainRequest() || (preg_match('/media\/cache\/resolve/', $event->getRequest()->getRequestUri()))) {
            return;
        }

        $route   = $event->getRequest()->attributes->get('_route');

        $locale  = $event->getRequest()->getLocale();
        /*        dump($event->getRequest()->getCurrentRequest()->attributes->get('_route'));
                dump($event->getRequest()->getCurrentRequest()->getLocale());*/
        /* $baseUrl  = $event->getRequest()->getCurrentRequest()->getSchemeAndHttpHost().'/';
         $lastPath = substr($referer, strpos($referer, $baseUrl) + strlen($baseUrl));*/
        if (!$event->getRequest()->getSession()->get('verify') && !$event->getRequest()->getSession()->get('route')) {

            $event->getRequest()->getSession()->set('route', $route);
        }

        if ($event->getRequest()->getSession()->get('route') && $event->getRequest()->getMethod() === Request::METHOD_POST && !$event->getRequest()->getSession()->get('verify')) {

            $event->getRequest()->getSession()->set('verify', true);
        }

        if ($event->getRequest()->getSession()->get('route') && ($event->getRequest()->getSession()->get('verify') === true) && $event->getRequest()->getMethod() === Request::METHOD_POST) {

			if($route == "homepage") {
                $route = $this->router->generate($route,['_locale' => $locale]);
            } else {
				return;
			}
            $response = new RedirectResponse($route);
            $event->setResponse($response);
        }

        if ($event->getRequest()->attributes->get('_route') != 'verify' && (!preg_match('/Controller\\\\Admin/', $event->getRequest()->attributes->get('_controller'))) && (!preg_match('/Controller\\\\Site\\\\MethodPaymentController/', $event->getRequest()->attributes->get('_controller'))) &&
            ((strpos($event->getRequest()->getPathInfo(), 'request') != 1)) && (strpos($event->getRequest()->getPathInfo(), '.well-known') != 1)
            && (strpos($event->getRequest()->getPathInfo(), '_wdt') != 1) && (strpos($event->getRequest()->getPathInfo(), '_profiler') != 1) && (!preg_match('/utm_campaign/', $event->getRequest()->getRequestUri()))) {
            if (!$event->getRequest()->getSession()->get('verify')) {
                $response = new RedirectResponse($this->router->generate('verify'));
                $event->setResponse($response);
            }
        }
    }
}
