<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\DependencyInjection\Compiler;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager\SocialNetworkProviderManager;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class SocialNetworkProviderPass implements CompilerPassInterface
{

    public function process(ContainerBuilder $container)
    {
        $definition = $container->findDefinition(SocialNetworkProviderManager::class);
        $taggedServices = $container->findTaggedServiceIds('viti-core.provider.socialnetwork');

        foreach ($taggedServices as $id => $tags) {
            // add the transport service to the TransportChain service
            $definition->addMethodCall('addProvider', [new Reference($id)]);
        }

    }

}
