<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;


use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ShippingAdditionalManualType;
use CpCreation\VitiCore\Shop\Model\ShippingAdditionalManual;
use CpCreation\VitiCore\Shop\Repository\ShippingAdditionalManualRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_SHIPPING')")
 * Class ShippingAdditionalManualController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/shipping-additionnal-manual")
 */
class ShippingAdditionalManualController extends AbstractController
{
    private $shippingAdditionalManualRepository;

    public function __construct(ShippingAdditionalManualRepository $shippingAdditionalManualRepository)
    {
        $this->shippingAdditionalManualRepository =  $shippingAdditionalManualRepository;
    }

    /**
     * @route("", name="admin_shipping_additional_manual")
     * @Template("@CpCreationVitiCore/admin/shipping/additional/manual/index.html.twig")
     */
    public function indexAction()
    {
        $additionals = $this->shippingAdditionalManualRepository->findBy([],['qtyAt' => 'ASC']);

        return [
            "items" =>  $additionals,
        ];
    }


    /**
     * @param Request $request
     * @Route("/new", name="admin_shipping_additional_manual_new")
     * @Template("@CpCreationVitiCore/admin/shipping/additional/manual/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(ShippingAdditionalManualType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ShippingAdditionalManual $data */
            $data = $form->getData();
            $this->shippingAdditionalManualRepository->save($data);
            $this->addFlash('alert-success', 'Le supplément a été ajouté avec succès');

            return $this->redirectToRoute('admin_shipping_additional_manual');

        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ShippingAdditionalManual $price
     * @param Request $request
     * @Route("/{id}/edit", name="admin_shipping_additional_manual_edit")
     * @Template("@CpCreationVitiCore/admin/shipping/additional/manual/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(ShippingAdditionalManual $price, Request $request)
    {
        $form = $this->createForm(ShippingAdditionalManualType::class, $price);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ShippingAdditionalManual $data */
            $data = $form->getData();
            $this->shippingAdditionalManualRepository->save($data);
            $this->addFlash('alert-success', 'Le supplément a été modifié avec succès');

            return $this->redirectToRoute('admin_shipping_additional_manual');

        }

        return [
            "item" => $price,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ShippingAdditionalManual $price
     * @Route("/{id}/delete", name="admin_shipping_additional_manual_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(ShippingAdditionalManual $price)
    {
        $this->shippingAdditionalManualRepository->delete($price);
        $this->addFlash('alert-success', 'Le supplément a été supprimé avec succès.');

        return $this->redirectToRoute('admin_shipping_additional_manual');
    }
}
