<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\News\Model;

use CpCreation\VitiCore\Behavior\HasImage;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Image;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class NewsImage
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\News\Repository\NewsImageRepository")
 * @ORM\Table(name="news_news_image")
 * @ORM\HasLifecycleCallbacks()
 */
class NewsImage implements HasTimestamp, HasImage
{
    use Timestamp, Image;

    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="CpCreation\VitiCore\News\Model\News", inversedBy="images")
     * @ORM\JoinColumn(name="news_id", referencedColumnName="id", onDelete="cascade")
     * @Gedmo\SortableGroup()
     *
     * @var News
     */
    private $news;


    /**
     * @Gedmo\SortablePosition()
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int
     */
    private $position;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return News
     */
    public function getNews(): ? News
    {
        return $this->news;
    }

    /**
     * @param News $news
     */
    public function setNews(News $news = null)
    {
        $this->news = $news;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position = null)
    {
        $this->position = $position;
    }
}