<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Media\Model;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Video
 *
 * @ORM\Entity()
 * @ORM\HasLifecycleCallbacks()
 */
class Video extends Media
{
    const PLATFORM = ['youtube'];

    /**
     * @ORM\Column(type="string", length=255)
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $platform;

    /**
     * @return string
     */
    public function getPlatform(): ?string
    {
        return $this->platform;
    }

    /**
     * @param string $platform
     */
    public function setPlatform(string $platform): void
    {
        $this->platform = self::PLATFORM;
    }
}

