<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Cart\Model;

use CpCreation\VitiCore\Behavior\HasDisable;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Disable;
use CpCreation\VitiCore\Behavior\Impl\SoftDeletable;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use CpCreation\VitiCore\Behavior\IsSoftDeletable;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class PaymentMethod
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Cart\Repository\PaymentMethodRepository")
 * @ORM\Table(name="cart_payment_method")
 * @ORM\HasLifecycleCallbacks()
 */
class PaymentMethod implements HasDisable, HasTimestamp, HasTranslatable, IsSoftDeletable
{
    use Disable, Timestamp, Translatable, SoftDeletable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank(groups={"step1"})
     *
     * @var string
     */
    private $method;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $paymentOnline;

    /**
     * @ORM\Column(type="integer", options={"default" : 0})
     * @Gedmo\SortablePosition()
     *
     * @var integer
     */
    private $position;
    
    public function __construct()
    {
        $this->id            = Uuid::uuid4();
        $this->disabled      = false;
        $this->paymentOnline = false;
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getMethod(): ?string
    {
        return $this->method;
    }

    /**
     * @param string $method
     */
    public function setMethod(string $method): void
    {
        $this->method = $method;
    }

    /**
     * @return bool
     */
    public function isPaymentOnline(): bool
    {
        return $this->paymentOnline;
    }

    /**
     * @param bool $paymentOnline
     */
    public function setPaymentOnline(bool $paymentOnline): void
    {
        $this->paymentOnline = $paymentOnline;
    }

    /**
     * @return int
     */
    public function getPosition(): int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position): void
    {
        $this->position = $position;
    }
}
