<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager\SocialNetworkNetworkManager;
use CpCreation\VitiCore\SocialNetwork\Model\SocialNetwork;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class
SocialNetworkStep2Type extends AbstractType
{
    private $manager;

    public function __construct(SocialNetworkNetworkManager $manager)
    {
        $this->manager = $manager;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->addEventListener(
            FormEvents::PRE_SET_DATA,
            [$this, 'onPreSetData']
        );
    }

    /**
     * @param FormEvent $event
     * @throws \Exception
     * @throws \ReflectionException
     */
    public function onPreSetData(FormEvent $event)
    {
        $form    = $event->getForm();
        $social  = $event->getData();
        $network = $social->getNetwork();
        $class   = $this->manager->createFormSocialNetworkManager($network);

        $form->add(
            'configuration', $class->getName(), [
                'label'    => false,
                'required' => true,
            ]
        );;
    }


    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => SocialNetwork::class,
            ]
        );
    }

    public function getBlockPrefix()
    {
        return 'socialNetworkStep2';
    }

}