<?php
/**
 * Created by Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PriceCollectionType extends AbstractType
{

    /**
     * @var array|ProductPriceGroup[]
     */
    private $priceGroups;

    public function __construct(ProductPriceGroupRepository $productPriceGroupRepository)
    {
        $this->priceGroups = $productPriceGroupRepository->findBy([], ['position' => 'ASC']);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
                'class' => null,
                'priceGroups' => []
            ]
        );
    }

    public function buildView(FormView $view, FormInterface $form, array $options)
    {
        $view->vars['priceGroups']= $this->priceGroups;
    }

    public function getParent()
    {
        return CollectionType::class;
    }

    public function getBlockPrefix()
    {
        return 'PriceCollectionType';
    }

}