<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use Craue\FormFlowBundle\Form\FormFlow;
use Craue\FormFlowBundle\Form\FormFlowInterface;

class PaymentMethodFlow extends FormFlow
{
    protected function loadStepsConfig()
    {
        return [
            [
                'label'        => 'Methode',
                'form_type'    => 'CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\PaymentMethodStep1Type',
                'form_options' => [
                    'validation_groups' => ['step1'],
                ],
                'skip'         => function ($estimatedCurrentStepNumber, FormFlowInterface $flow) {
            
                    return $flow->getFormData()->getMethod() !== null;
                },
            ],
            [
                'label'        => 'Config',
                'form_type'    => 'CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\PaymentMethodStep2Type',
                'form_options' => [
                    'validation_groups' => ['step2'],
                ],
            ],
        ];
    }
}
