<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\Payment;

use CpCreation\VitiCore\Cart\Model\Payment\Etransactions;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class EtransactionsPaymentType extends AbstractType implements PaymentMethodInterface, DataTransformerInterface
{
    const TYPE = 'e-transactions';

    private $serializer;

    public function __construct()
    {
        $normalizers = [new ObjectNormalizer()];
        $this->serializer = new Serializer($normalizers);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class,[
                'label' => 'Nom',
                'required'    => true
            ])
            ->add('production', ChoiceType::class, [
                'choices' => [
                    'production' => true,
                    'test' => false,
                ],
                'label'       => 'Production',
                'required'    => true
            ])
            ->add('site', TextType::class, [
                'label'       => 'Site',
                'required'    => true
            ])
            ->add('rank', TextType::class, [
                'label'       => 'Rang',
                'required'    => true
            ])
            ->add('login', TextType::class, [
                'label'       => 'Identifiant',
                'required'    => true
            ])
            ->add('hmacKey', TextType::class, [
                'label'       => 'HMAC KEY',
                'required'    => true
            ])
            ->add('hmacAlgo', ChoiceType::class, [
                'choices' => [
                    'SHA512' => 'SHA512'
                ],
                'label'       => 'HMAC ALGO',
                'required'    => true
            ])

        ;

        $builder->addModelTransformer($this);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Etransactions::class
        ]);
    }

    public function transform($data)
    {

        return $this->serializer->denormalize($data, Etransactions::class);
    }

    public function reverseTransform($data)
    {

        return $this->serializer->normalize($data);
    }

    public function getMethod()
    {
        return static::TYPE;
    }

    public function getBlockPrefix()
    {
        return 'etransactions_payment';
    }
}