<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model;

use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ShippingAuto
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Shop\Repository\ShippingAutoRepository")
 * @ORM\Table(name="shop_shipping_auto")
 * @ORM\HasLifecycleCallbacks()
 */
class ShippingAuto
{
    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="integer")
     * @Assert\NotBlank()
     *
     * @var integer
     */
    private $qtyOf;

    /**
     * @ORM\Column(type="integer")
     * @Assert\NotBlank()
     *
     * @var integer
     */
    private $qtyAt;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int
     */
    private $packagePrice;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int
     */
    private $bottlePrice;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $county;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $country;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $hM;


    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->hM = false;
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getQtyOf(): ?int
    {
        return $this->qtyOf;
    }

    /**
     * @param int $qtyOf
     */
    public function setQtyOf(?int $qtyOf)
    {
        $this->qtyOf = $qtyOf;
    }

    /**
     * @return int
     */
    public function getQtyAt(): ?int
    {
        return $this->qtyAt;
    }

    /**
     * @param int $qtyAt
     */
    public function setQtyAt(?int $qtyAt)
    {
        $this->qtyAt = $qtyAt;
    }

    /**
     * @return int
     */
    public function getPackagePrice(): ?int
    {
        return $this->packagePrice;
    }

    /**
     * @param int $packagePrice
     */
    public function setPackagePrice(?int $packagePrice)
    {
        $this->packagePrice = $packagePrice;
    }

    /**
     * @return int
     */
    public function getBottlePrice(): ?int
    {
        return $this->bottlePrice;
    }

    /**
     * @param int $bottlePrice
     */
    public function setBottlePrice(?int $bottlePrice)
    {
        $this->bottlePrice = $bottlePrice;
    }

    /**
     * @return string
     */
    public function getCounty(): ?string
    {
        return $this->county;
    }

    /**
     * @param string $county
     */
    public function setCounty(?string $county)
    {
        $this->county = $county;
    }

    /**
     * @return string
     */
    public function getCountry(): ?string
    {
        return $this->country;
    }

    /**
     * @param string $country
     */
    public function setCountry(?string $country)
    {
        $this->country = $country;
    }

    /**
     * @return bool
     */
    public function isHM(): bool
    {
        return $this->hM;
    }

    /**
     * @param bool $hM
     */
    public function setHM(bool $hM)
    {
        $this->hM = $hM;
    }
}
