<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Knp\DoctrineBehaviors\Contract\Entity\TranslatableInterface;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Ramsey\Uuid\UuidInterface;


/**
 * Class ProductTypeOptionTranslation
 * @ORM\Entity()
 * @ORM\Table(name="product_option_translation")
 */
class ProductTypeOptionTranslation implements TranslationInterface
{
    use Translation;

    /**
     * L'évènement LoadClassMetaData de TransaltableEventsubscriber ne se lance pas pour ProductTypeTranslation ( Nous n'avons pas trouvé pourquoi .. ). C'est pour cela que nous inscrivons la relation en annotation
     * @ORM\ManyToOne(targetEntity="CpCreation\VitiCore\Product\Model\ProductTypeOption", inversedBy="translations", cascade={"persist","merge"})
     * @ORM\JoinColumn(name="translatable_id", referencedColumnName="id", onDelete="CASCADE")
     *
     * @var TranslatableInterface
     */
    protected $translatable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @var UuidInterface
     */
    private UuidInterface $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @var string
     */
    private string $text;

    public function __construct(){
        $this->id = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @param string $text
     */
    public function setText(string $text): void
    {
        $this->text = $text;
    }
}