<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;


use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Shop\Model\ShippingCountry;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CountryType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ShippingCountryType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'code', CountryType::class,
                [
                    'label'    => 'Pays',
                    'multiple' => false,
                    'attr'     => [
                        'class' => 'select2',
                    ],
                    'required' => true,
                ]
            )
            ->add(
                'county', CheckboxType::class,
                [
                    'label' => 'Activer la gestion des départements ',
                    'required' => false,
                ]
            )
            ->add(
                'disabled', CheckboxType::class,
                [
                    'label' => 'Désactiver le pays',
                    'required' => false,
                ]
            )
            ->add(
                'minQty', IntegerType::class,
                [
                    'label' => 'Quantité minimum (équivalence bouteille) pour commander vers ce pays avec le groupe désigné ci-dessous. Ne rien mettre si on prend la configuration par défaut',
                    'required' => false
                ]
            )
            ->add(
                'multiple', IntegerType::class,
                [
                    'label' => 'Multiple (équivalence bouteille) pour commander vers ce pays avec le groupe désigné ci-dessous. Ne rien mettre si on prend la configuration par défaut',
                    'required' => false
                ]
            )
            ->add(
                'groups', EntityType::class,
                [
                    'class'        => ProductPriceGroup::class,
                    'query_builder' => function (ProductPriceGroupRepository $er) {
                        return $er->findByNameOrderAdminQuery();
                    },
                    'choice_label' => 'name',
                    'label'        => 'Groupes de prix',
                    'multiple'     => true,
                    'required'     => true,
                    'attr'         => [
                        'class' => 'select2',
                    ],
                ]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ShippingCountry::class,
            ]
        );
    }
}
