<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslatedEntityType;
use CpCreation\VitiCore\Product\Model\Product;
use CpCreation\VitiCore\Product\Model\ProductDegressive;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Model\ProductType;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\PercentType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use CpCreation\VitiCore\Product\Model\ProductType as ModelProductType;

class ProductDegressiveType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('qtyOf', IntegerType::class, ['label' => 'De (>)', 'required' => true])
            ->add('qtyAt', IntegerType::class, ['label' => 'A (<=)', 'required' => true])
            ->add('allQuantity', CheckboxType::class, ['label' => 'Cocher pour calculer sur toute la quantité commandée', 'required' => false])
            ->add('equivalency', CheckboxType::class, ['label' => 'Cocher pour transformer tous les types en équivalence par défaut. Le calcul de la degréssivité se fera avec tous les types et leur équivalence. Mettre seulement le type par défaut dans Types ci-dessus (Bouteille). La plupart du temps cette case sera cochée', 'required' => false])
            ->add(
                'types', TranslatedEntityType::class,
                [
                    'class'                => ModelProductType::class,
                    'translation_property' => 'name',
                    'label'                => 'Type(s) pris en compte',
                    'choice_label'         => function (ProductType $type) {
                        if ($type->getInfo())
                        {
                            return $type->getName().'('.$type->getInfo().')';
                        }else{
                            return $type->getName();
                        }

                    },
                    'multiple'             => true,
                    'required'             => true,
                    'attr'                 => [
                        'class' => 'select2',
                    ],
                ]
            )
            ->add(
                'packagePrice', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'remise en Euros sur le total (HT ou TTC)',
                    'required' => false,
                ]
            )
            ->add(
                'bottlePrice', MoneyType::class,
                [
                    'divisor'  => 100,
                    'label'    => 'remise en Euro par bouteille (HT ou TTC)',
                    'required' => false,
                ]
            )
            ->add(
                'packagePercent', PercentType::class, [
                    'scale'    => 2,
                    'label'    => 'remise en % sur le total',
                    'required' => false,
                ]
            )
            ->add('qtyOfBottleOffered', IntegerType::class, [
                'label'    => 'ou quantité de bouteille offerte (la moins chère)',
                'required' => false,
            ])
            ->add('mostOrderBottleInCart', CheckboxType::class, [
                'label' => 'remise sur la bouteille la plus commandé du panier (ne prends en compte que le ProductType par default - sera souvent bouteille), uniquement en équivalence bouteille',
                'required' => false,
            ])

            ->add(
                'products', TranslatedEntityType::class, [
                    'label'                => 'Produit(s) associé(s) à la dégressivité',
                    'class'                => Product::class,
                    'translation_property' => 'fullName',
                    'required'             => false,
                    'multiple'             => true,
                    'help'         => 'laisser vide pour prendre en compte tous les produits',
                    'attr'         => [
                        'class' => 'select2',
                    ],
                ]
            )
            ->add(
                'groups', EntityType::class,
                [
                    'class'        => ProductPriceGroup::class,
                    'query_builder' => function (ProductPriceGroupRepository $er) {
                        return $er->findByNameOrderAdminQuery();
                    },
                    'choice_label' => 'name',
                    'label'        => 'Groupes de prix',
                    'multiple'     => true,
                    'required'     => true,
                    'attr'         => [
                        'class' => 'select2',
                    ],
                ]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ProductDegressive::class,
            ]
        );
    }
}
