<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Contact\Model\Label;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class LabelType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                    'label'  => false,
                    'fields' => [
                        'text' => [
                            'field_type' => TextType::class,
                            'label'      => 'Texte',
                            'required'   => false,
                        ],
                    ]
                ]
            )
            ->add(
                'image', ImageType::class, [
                    'label'          => 'Image',
                     'required'   => true
                ]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                "data_class" => Label::class
            ]
        );
    }
}