<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Command;

use CpCreation\VitiCore\Contact\Model\Contact;
use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use Doctrine\ORM\EntityManager;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\Finder\Finder;

class FixtureProdCommand extends Command implements ContainerAwareInterface
{
    use ContainerAwareTrait;

    private $contactRepository;

    public function __construct(ContactRepository $contactRepository)
    {
        parent::__construct();
        $this->contactRepository = $contactRepository;
    }

    protected function configure()
    {
        $this->setName('viti-core:fixture-prod:create');
    }

    /**
     * @param InputInterface  $input
     * @param OutputInterface $output
     * @return int|void
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $io = new SymfonyStyle($input, $output);

        /** @var Contact $contact */
        $contact = $this->contactRepository->findOne();
        $files   = [];
        if (!$contact) {
            foreach (Finder::create()->in(__DIR__.'/../../../../fixtures/prod')->getIterator() as $file) {
                $files[] = $file;
            }
            $loader = $this->container->get('fidry_alice_data_fixtures.loader.doctrine');
            $loader->load($files);

        }

        $io->comment('First launch Prod, fixture');

        return Command::SUCCESS;
    }
}
