<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Util;

class Slugifier
{
    private $symbolMap = [
        ' ' => '-',
        '_' => '-',
    ];

    /**
     * @var \Transliterator
     */
    private $transliterator;

    public function __construct()
    {
        $this->transliterator = \Transliterator::createFromRules("::Latin-ASCII; ::Lower; [^[:L:]]+ > '-';");
    }

    public function __invoke($source): string
    {
        return trim(strtr($this->transliterator->transliterate($source), $this->symbolMap), '-');
    }
}