<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\SocialNetwork\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use ApiPlatform\Core\Annotation\ApiProperty;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class SocialNetwork
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\SocialNetwork\Repository\SocialNetworkRepository")
 * @ORM\Table(name="socialnetwork_socialnetwork")
 * @ORM\HasLifecycleCallbacks()
 */
class SocialNetwork implements HasTimestamp
{
    use Timestamp;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     * @ApiProperty(iri="https://schema.org/identifier")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank(groups={"step1"})
     *
     * @var string
     */
    private $network;

    /**
     * @ORM\Column(type="json", nullable=true)
     * @Assert\NotBlank(groups={"step2"})
     *
     * @var array
     */
    private $configuration;

    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @var string
     */
    private $token;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     *
     * @var \DateTimeInterface
     */
    private $tokenAt;

    /**
     * @var array
     *
     * @ORM\Column(type="json")
     */
    private $data;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->data = [];
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getNetwork(): ?string
    {
        return $this->network;
    }

    /**
     * @param string $network
     */
    public function setNetwork(?string $network)
    {
        $this->network = $network;
    }

    /**
     * @return array
     */
    public function getConfiguration(): ?array
    {
        return $this->configuration;
    }

    /**
     * @param array $configuration
     */
    public function setConfiguration(?array $configuration)
    {
        $this->configuration = $configuration;
    }

    /**
     * @return string
     */
    public function getToken(): ?string
    {
        return $this->token;
    }

    /**
     * @param string $token
     */
    public function setToken(?string $token = null)
    {
        $this->token = $token;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getTokenAt(): ?\DateTimeInterface
    {
        return $this->tokenAt;
    }

    /**
     * @param \DateTimeInterface $tokenAt
     */
    public function setTokenAt(?\DateTimeInterface $tokenAt = null)
    {
        $this->tokenAt = $tokenAt;
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @param array $data
     */
    public function setData(array $data)
    {
        $this->data = $data;
    }

}
