<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Repository;

use CpCreation\VitiCore\Repository\BaseRepository;
use CpCreation\VitiCore\Shop\Model\ShopConfig;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\Persistence\ManagerRegistry;

class ShopConfigRepository extends BaseRepository
{
    /**
     * ShopConfigRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ShopConfig::class);
    }

    /**
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findOne()
    {
        $qb = $this->createQueryBuilder('r')
                   ->addSelect('tr')
                   ->innerJoin('r.translations', 'tr', Join::WITH, 'tr.translatable = r.id')
                   ->orderBy('r.createdAt', 'DESC');

        $query = $qb->getQuery();

        if ($query->getResult()) {
            return $query->getResult()[0];
        } else {
            return $query->getResult();
        }
    }
}
