<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\SoftDeletable;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\IsSoftDeletable;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class ProductPriceGroup
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository")
 * @ORM\Table(name="product_price_group")
 * @ORM\HasLifecycleCallbacks()
 */
class ProductPriceGroup implements HasTimestamp, IsSoftDeletable
{
    use Timestamp, SoftDeletable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="text", length=255)
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $name;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $byDefault;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $viewHT;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $freeShipping;

    /**
     * @ORM\OneToMany(targetEntity="ProductPrice", cascade={"remove"}, mappedBy="group")
     *
     * @var ArrayCollection
     */
    protected $prices;

    /**
     * @Gedmo\SortablePosition()
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int
     */
    private $position;

    /**
     * @ORM\OneToMany(targetEntity="ProductPriceCode", cascade={"remove"}, mappedBy="group")
     *
     * @var Collection
     */
    private $codes;

    public function __construct()
    {
        $this->id      = Uuid::uuid4();
        $this->byDefault = false;
        $this->viewHT = false;
        $this->freeShipping = false;
        $this->codes = new ArrayCollection();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @return bool
     */
    public function isByDefault(): bool
    {
        return $this->byDefault;
    }

    /**
     * @param bool $byDefault
     */
    public function setByDefault(bool $byDefault): void
    {
        $this->byDefault = $byDefault;
    }

    /**
     * @return bool
     */
    public function isViewHT(): bool
    {
        return $this->viewHT;
    }

    /**
     * @return bool
     */
    public function isFreeShipping(): bool
    {
        return $this->freeShipping;
    }

    /**
     * @param bool $freeShipping
     */
    public function setFreeShipping(bool $freeShipping)
    {
        $this->freeShipping = $freeShipping;
    }

    /**
     * @param bool $viewHT
     */
    public function setViewHT(bool $viewHT): void
    {
        $this->viewHT = $viewHT;
    }

    /**
     * @param string $name
     */
    public function setName(string $name = null): void
    {
        $this->name = $name;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position)
    {
        $this->position = $position;
    }

    /**
     * @return Collection
     */
    public function getCodes(): Collection
    {
        return $this->codes;
    }

}
