<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model;

use CpCreation\VitiCore\Behavior\HasFile;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\File;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class ProductFile
 *
 * @ORM\Entity()
 * @ORM\Table(name="product_product_files")
 * @ORM\HasLifecycleCallbacks()
 */
class ProductFile implements HasTimestamp, HasFile
{
    use Timestamp, File;

    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="CpCreation\VitiCore\Product\Model\Product", inversedBy="files")
     * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="cascade", nullable=true)
     *
     * @var Product
     */
    private $product;

    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @var string|null
     */
    private $locale;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return Product|null
     */
    public function getProduct(): ?Product
    {
        return $this->product;
    }

    /**
     * @param Product $product
     */
    public function setProduct(?Product $product): void
    {
        $this->product = $product;
    }

    /**
     * @return string|null
     */
    public function getLocale(): ?string
    {
        return $this->locale;
    }

    /**
     * @param string|null $locale
     */
    public function setLocale(?string $locale): void
    {
        $this->locale = $locale;
    }

}
