<?php
/**
 * @author Colinet Julien
 */
namespace CpCreation\VitiCore\Depot\Repository;

use CpCreation\VitiCore\Depot\Model\Category;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\Persistence\ManagerRegistry;

class CategoryRepository extends BaseRepository
{
    /**
     * CategoryRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Category::class);
    }

    public function findCategories()
    {

        $qb = $this
            ->createQueryBuilder('cat')
            ->innerJoin('cat.depots', 'depot')
            ->andWhere('depot.disabled = FALSE')
            ->addOrderBy('cat.position', 'ASC')
            ->getQuery();

        return $qb->execute();
    }
}