import {load} from 'recaptcha-v3-enterprise';


export default {
    init() {
        const RECAPTCHA_KEY_PUBLIC = process.env.RECAPTCHA_V3_PUBLIC;
        this.recaptchaV3forms = document.querySelectorAll('.g_recaptcha');
        this.recaptchaV3forms.forEach((item, index) => {
            let id = item.getAttribute('id');
            load(RECAPTCHA_KEY_PUBLIC, {
                useRecaptchaNet: false,
                autoHideBadge: true
            }).then((recaptcha) => {
                recaptcha.execute(id).then((token) => {
                    item.value = token;
                })
            });
            setInterval(() => {
                load(RECAPTCHA_KEY_PUBLIC, {
                    useRecaptchaNet: false,
                    autoHideBadge: true
                }).then((recaptcha) => {
                    recaptcha.execute(id).then((token) => {
                        item.value = token;
                    })
                });
            }, 60000);

        });

        this.recaptchaEnterpriseforms = document.querySelectorAll('.g_recaptcha_enterprise');
        this.recaptchaEnterpriseforms.forEach((item, index) => {
            let id = item.getAttribute('id');
            load(RECAPTCHA_KEY_PUBLIC, {
                useRecaptchaNet: false,
                autoHideBadge: true
            }).then((recaptcha) => {
                recaptcha.execute(id).then((token) => {
                    item.value = token;
                })
            });
            setInterval(() => {
                load(RECAPTCHA_KEY_PUBLIC, {
                    useRecaptchaNet: false,
                    autoHideBadge: true
                }).then((recaptcha) => {
                    recaptcha.execute(id).then((token) => {
                        item.value = token;
                    })
                });
            }, 60000);
        });
    }
}
