<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager;

use CpCreation\VitiCore\Behavior\HasPayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\Payment\PaymentProviderInterface;
use CpCreation\VitiCore\Contact\Model\Contact;

class PaymentProviderManager
{
    private $providers = [];

    /**
     * @param PaymentProviderInterface $provider
     */
    public function addProvider(PaymentProviderInterface $provider)
    {
        $this->providers[] = $provider;
    }

    /**
     * @param Contact    $contact
     * @param HasPayment $payment
     * @return mixed
     * @throws \Exception
     */
    public function createPaymentProviderManager(Contact $contact, HasPayment $payment)
    {
        foreach ($this->providers as $item) {
            if ($item->getMethod() === $payment->getPaymentMethod()->getMethod()) {
                return $item->checkout($contact, $payment);
            }
        }

        throw new \Exception("Pas de provider de paiement trouvé");

    }
}
