<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Shop\Model\ShopConfig;
use CpCreation\VitiCore\Shop\Model\ShopConfigDisableCountry;
use CpCreation\VitiCore\Shop\Model\ShopConfigMultiple;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\CountryType;
use Symfony\Component\Form\Extension\Core\Type\DateIntervalType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\ColorType;

class ShopConfigType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('viewCategory', CheckboxType::class, ['label'    => 'Afficher les catégories produits',
                                                        'required' => false,
            ])
            ->add('viewOrderByCategory', CheckboxType::class, ['label'    => 'Afficher les cuvées rangées par catégorie avec le titre de la catégorie ',
                                                               'required' => false,
            ])
            ->add('hidePriceDefault', CheckboxType::class, ['label'    => 'Afficher la boutique sans prix',
                                                            'required' => false,
            ])
            ->add(
                'otherDeliveryMethodColor', ColorType::class, ['label' => 'Couleur de la zone "Autres modes de livraison"', 'required' => false]
            )
            ->add('disableLogoBank', CheckboxType::class, ['label'    => 'Ne plus afficher le logo de la banque',
                                                           'required' => false,
            ])
            ->add('viewFavoriteCat', CheckboxType::class, ['label'    => 'Afficher la catégorie Favoris dans la vue avec Swipe des catégories de la boutique',
                                                           'required' => false,
            ])
            ->add('enabledCityField', CheckboxType::class, ['label'    => 'Activer le champ Ville dans la boutique',
                                                            'required' => false,
            ])
            ->add('enableAwardShop', CheckboxType::class, ['label'    => 'Afficher les médailles sur les produits dans la boutique',
                                                           'required' => false,
            ])
            ->add('degrissivityByItem', CheckboxType::class, ['label'    => 'Calculer la dégréssivité independement pour chaque item du panier. Ne fonctionne pas avec la remise "une bouteille offerte" (ex : Champagne Michel Gaillot )',
                                                           'required' => false,
            ])
            ->add('disableShopForVacation', CheckboxType::class, ['label'    => 'Désactiver la boutique pendant les vacances',
                                                                  'required' => false,
            ])
            ->add('enableCountriesForShop', CountryType::class, [
                'label'    => 'Activer seulement la boutique pour les pays ci-dessous',
                'multiple' => true,
                'attr'     => [
                    'class' => 'select2',
                ],
                'required' => false,
            ])
            ->add(
                'disableCountries', CollectionType::class, [
                    'label'          => false,
                    'entry_type'     => ShopConfigDisableCountryType::class,
                    'allow_add'      => true,
                    'allow_delete'   => true,
                    'error_bubbling' => false,
                    'prototype'      => true,
                    'by_reference'   => false,
                    'delete_empty'   => true,
                    'attr'           => [
                        'data-name-prefix' => 'Collection',
                        'class'            => "disable-country-collection",
                    ],
                    'entry_options'  => [
                        'data_class' => ShopConfigDisableCountry::class,
                        'label'      => false,
                    ],
                ]
            )
            ->add('maxAwardsVisibleInShop', TextType::class, ['label'    => 'Nombre de médaille maximum à afficher sur la boutique',
                                                              'required' => false,
            ])
            ->add(
                'translations', TranslationsType::class, [
                    'label'    => false,
                    'required' => false,
                    'fields'   => [
                        'favoriteCatName' => [
                            'field_type' => TextType::class,
                            'label'      => 'Nom de la catégorie "Favoris" ',
                            'required'   => false,
                        ],
                        'vacation'        => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Text à afficher lorsque la boutique est en vacances',
                            'required'   => false,
                        ],
                    ],
                ]
            )
            ->add(
                'multiples', CollectionType::class, [
                    'label'          => false,
                    'entry_type'     => ShopConfigMultipleType::class,
                    'allow_add'      => true,
                    'allow_delete'   => true,
                    'error_bubbling' => false,
                    'prototype'      => true,
                    'by_reference'   => false,
                    'delete_empty'   => true,
                    'attr'           => [
                        'data-name-prefix' => 'Collection',
                        'class'            => "multiple-collection",
                    ],
                    'entry_options'  => [
                        'data_class' => ShopConfigMultiple::class,
                        'label'      => false,
                    ],
                ]
            )
            ->add(
                'vacationOf', DateTimeType::class, [
                    'required' => false,
                    'label'    => 'Début des vacances',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'html5'    => false,
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',

                    ],
                ]
            )
            ->add(
                'vacationAt', DateTimeType::class, [
                    'required' => false,
                    'label'    => 'Fin des vacances',
                    'input'    => 'datetime',
                    'format'   => 'yyyy-MM-dd HH:mm',
                    'html5'    => false,
                    'widget'   => 'single_text',
                    'attr'     => [
                        'class' => 'datetimepicker',

                    ],
                ]
            )
            ->add('giftCardCheckToken', TextType::class, [
                'required' => false,
                'label'    => 'Token de validation des cartes cadeaux',
            ])
            ->add('giftCardValidTime', DateIntervalType::class, [
                'required'    => false,
                'label'       => "Temps de validité des cartes cadeaux",
                'widget'      => 'integer',
                'with_years'  => false,
                'with_months' => true,
                'with_days'   => false,
                'with_hours'  => false,
                'labels' => [
                    'months' => 'Mois'
                ]
            ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ShopConfig::class,
            ]
        );
    }
}
