<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\Payment;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;
use CpCreation\VitiCore\Cart\Model\Payment\Sherlock2;
use function Sodium\add;

class Sherlock2PaymentType extends AbstractType implements PaymentMethodInterface, DataTransformerInterface
{
    const TYPE = 'sherlock2';

    private $serializer;

    public function __construct()
    {
        $normalizers = [new ObjectNormalizer()];
        $this->serializer = new Serializer($normalizers);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name',TextType::class,[
                'label' => "Nom de la méthode de paiement",
                'required' => true
            ])
            ->add('production', ChoiceType::class, [
                'choices' => [
                    'production' => true,
                    'test' => false,
                ],
                'label'       => 'Production',
                'required'    => true
            ])
            ->add('merchantId', TextType::class,[
                'label' => 'ID du commerçant',
                'required' => true
            ])
            ->add('secretKey', TextType::class,[
                'label' => 'Clé secrète',
                'required' => true
            ])
            ->add('KeyVersion', TextType::class, [
                'label' => 'Version de la clé',
                'required' => true
            ])
        ;

        $builder->addModelTransformer($this);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Sherlock2::class
        ]);
    }

    public function transform($data)
    {

        return $this->serializer->denormalize($data, Sherlock2::class);
    }

    public function reverseTransform($data)
    {

        return $this->serializer->normalize($data);
    }

    public function getMethod()
    {
        return static::TYPE;
    }

    public function getBlockPrefix()
    {
        return 'sherlock2_payment';
    }
}
