<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Depot\Model\Depot;
use CpCreation\VitiCore\Locale\Model\Locale;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\Choice;

class LocaleType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, ['label' => 'Nom', 'required' => true])
            ->add(
                'locale', ChoiceType::class, [
                'label'    => 'locale',
                'choices' =>
                [
                    'Anglais' => 'en',
                    'Allemand' => 'de',
                    'Espagnol' => 'es',
                    'Italien' => 'it',
                    'Néerlandais' => 'nl',
                    'Russe' => 'ru'

                ],
                'required' => true,
            ])
            ->add(
                'disabled', CheckboxType::class, ['label' => 'Dépublié', 'required' => false]

            );

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                "data_class" => Locale::class,
            ]
        );
    }
}
