<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\News\Model\Category;
use CpCreation\VitiCore\News\Repository\CategoryRepository;
use CpCreation\VitiCore\News\Repository\NewsRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class NewsController extends AbstractController
{
    private $newsRepository;
    private $categoryRepository;

    public function __construct(NewsRepository $newsRepository, CategoryRepository $categoryRepository)
    {
        $this->newsRepository     = $newsRepository;
        $this->categoryRepository = $categoryRepository;
    }

    /**
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        $subMenu        = false;
        $news           = $this->newsRepository->findAvailableAndPublish();
        $categoriesNews = $this->categoryRepository->findBy([], ['position' => 'ASC']);
        if ($categoriesNews) {
            $subMenu = true;
        }

        return $this->render(
            'news.html.twig',
            [
                'classMenu'      => 'black',
                'subMenu'        => $subMenu,
                'news'           => $news,
                'categoriesNews' => $categoriesNews,
            ]
        );
    }

    /**
     * @param Category $category
     * @ParamConverter("category", converter="translation_converter")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function categoryAction(Category $category)
    {
        $categoriesNews = $this->categoryRepository->findBy([], ['position' => 'ASC']);

        return $this->render(
            'news_category.html.twig',
            [
                'classMenu'      => 'black',
                'subMenu'        => true,
                'category'       => $category,
                'categoriesNews' => $categoriesNews,
            ]
        );
    }
}
