<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;

class ConfidentialityController extends AbstractController
{


    private $contactRepository;

    public function __construct(ContactRepository $contactRepository)
    {
        $this->contactRepository = $contactRepository;
    }

    /**
     * @Route({
     *     "fr": "/politique-de-confidentialite",
     *     "en": "/en/privacy_policy"
     * }, name="privacy-policy")
     *
     * @return array
     */
    public function indexAction()
    {
        $contact = $this->contactRepository->findOne();
        return $this->render(
            'privacy_policy.html.twig',
            [
                'classMenu'          => 'black',
                'contact'            => $contact
            ]
        );
    }
}
