<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\SocialNetworkFlow;
use CpCreation\VitiCore\SocialNetwork\Model\SocialNetwork;
use CpCreation\VitiCore\SocialNetwork\Repository\SocialNetworkRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_SOCIAL')")
 * Class SocialNetworkController
 *
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/social-network")
 */
class SocialNetworkController extends AbstractController
{
    private $socialNetworkRepository;
    private $socialNetworkFlow;


    public function __construct(SocialNetworkRepository $socialNetworkRepository, SocialNetworkFlow $socialNetworkFlow)
    {
        $this->socialNetworkRepository = $socialNetworkRepository;
        $this->socialNetworkFlow       = $socialNetworkFlow;
    }

    /**
     * @route("", name="admin_social")
     * @Template("@CpCreationVitiCore/admin/social/index.html.twig")
     */
    public function indexAction()
    {
        $socials = $this->socialNetworkRepository->findAll();

        return [
            "items" => $socials,
        ];
    }

    /**
     * @param Request $request
     * @Route("/new", name="admin_social_new")
     * @Template("@CpCreationVitiCore/admin/social/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $formData = new SocialNetwork(); // Your form data class. Has to be an object, won't work properly with an array.
        $flow     = $this->socialNetworkFlow; // must match the flow's service id
        $flow->bind($formData);

        // form of the current step
        $form = $flow->createForm();
        if ($flow->isValid($form)) {
            $flow->saveCurrentStepData($form);
            if ($flow->nextStep()) {
                $form = $flow->createForm();
            } else {
                $data = $form->getData();
                $this->socialNetworkRepository->save($data);
                $this->addFlash('alert-success', 'Le réseau social '.$data->getNetwork().' a été ajouté avec succès');
                $flow->reset(); // remove step data from the session

                return $this->redirectToRoute('admin_social');
            }
        }

        return [
            'form' => $form->createView(),
            'flow' => $flow,
        ];
    }

    /**
     * @param SocialNetwork $social
     * @param Request       $request
     * @Route("/{id}/edit", name="admin_social_edit")
     * @Template("@CpCreationVitiCore/admin/social/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(SocialNetwork $social, Request $request)
    {
        $flow = $this->socialNetworkFlow; // must match the flow's service id
        $flow->bind($social);

        // form of the current step
        $form = $flow->createForm();
        if ($flow->isValid($form)) {
            $flow->saveCurrentStepData($form);
            if ($flow->nextStep()) {
                $form = $flow->createForm();
            } else {
                $data = $form->getData();
                $this->socialNetworkRepository->save($data);
                $this->addFlash('alert-success', 'Le réseau social '.$data->getNetwork().' a été modifié avec succès');
                $flow->reset(); // remove step data from the session

                return $this->redirectToRoute('admin_social');
            }
        }

        return [
            'form' => $form->createView(),
            'item' => $social,
            'flow' => $flow,
        ];
    }

    /**
     * @param SocialNetwork $social
     * @Route("/{id}/delete", name="admin_social_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(SocialNetwork $social)
    {
        $this->socialNetworkRepository->delete($social);
        $this->addFlash('alert-success', 'Le contact '.$social->getNetwork().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_social');
    }
}
