<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior\Impl;

use Knp\DoctrineBehaviors\Model\Translatable\TranslationTrait;

trait Translation
{
    use TranslationTrait;

    public static function getTranslatableEntityClass(): string
    {
        $explodedNamespace = explode('\\', __CLASS__);
        $entityClass = array_pop($explodedNamespace);
        // Remove Translation namespace
        array_pop($explodedNamespace);
        return '\\'.implode('\\', $explodedNamespace).'\\'.substr($entityClass, 0, -11);
    }
}
