<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior\Impl;

use CpCreation\VitiCore\Media\Model\Image;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

trait Images
{
    /**
     * @ORM\ManyToMany(targetEntity="CpCreation\VitiCore\Media\Model\Image", cascade={"persist","remove"})
     *
     * @var Collection<Image>
     */
    private $images;

    public function addImage(Image $image): void
    {
        $this->images[] = $image;
    }

    public function removeImage(Image $image)
    {
        $this->images->removeElement($image);
    }

    /**
     * @return Collection<Image>
     */
    public function getImages(): Collection
    {
        return $this->images;
    }

    /**
     * @ORM\PrePersist()
     */
    public function generateImageCollectionIfEmpty()
    {
        if (null === $this->images) {
            $this->images = new ArrayCollection();
        }
    }
}
