<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\SocialNetwork\Repository;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Client\ConnectCpCreationClient;
use CpCreation\VitiCore\Repository\BaseRepository;
use CpCreation\VitiCore\SocialNetwork\Model\SocialNetworkNew;
use Doctrine\Persistence\ManagerRegistry;

class SocialNetworkNewRepository extends BaseRepository
{
    private $connectCpCreationClient;

    /**
     * SocialNetworkNewRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry, ConnectCpCreationClient $connectCpCreationClient)
    {
        $this->connectCpCreationClient = $connectCpCreationClient;
        parent::__construct($registry, SocialNetworkNew::class);
    }

    /**
     * @param $social
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findByLikeSocial($social)
    {
        $qb = $this->createQueryBuilder('socialNetworkNew')
                   ->andWhere('socialNetworkNew.network LIKE :social')
                   ->setParameter('social', '%'.$social.'%')
                   ->orderBy('socialNetworkNew.createdAt', 'DESC')
                   ->setMaxResults(1);

        return $qb->getQuery()->getOneOrNullResult();

    }

    /**
     * @param $social
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findByConnectId($id)
    {
        $qb = $this->createQueryBuilder('socialNetworkNew')
                   ->andWhere('socialNetworkNew.connectId = :connectId')
                   ->setParameter('connectId', $id)
                   ->orderBy('socialNetworkNew.createdAt', 'DESC')
                   ->setMaxResults(1);

        return $qb->getQuery()->getOneOrNullResult();

    }

    public function removeInstagram(SocialNetworkNew $socialNetworkNew)
    {
        //$this->connectCpCreationClient->delete('api/client_socials/'.$socialNetworkNew->getConnectId());

        $this->delete($socialNetworkNew);

    }
}
