<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Season\Model;

use CpCreation\VitiCore\Behavior\HasImage;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Image;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Context\ExecutionContextInterface;

/**
 * Class SeasonImage
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Season\Repository\SeasonImageRepository")
 * @ORM\Table(name="season_season_image")
 * @ORM\HasLifecycleCallbacks()
 */
class SeasonImage implements HasTimestamp, HasImage
{
    use Timestamp, Image;

    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="CpCreation\VitiCore\Season\Model\Season", inversedBy="images")
     * @ORM\JoinColumn(name="season_id", referencedColumnName="id", onDelete="cascade")
     * @Gedmo\SortableGroup()
     *
     * @var Season
     */
    private $season;

    /**
     * @Gedmo\SortablePosition()
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int
     */
    private $position;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return Season
     */
    public function getSeason(): Season
    {
        return $this->season;
    }

    /**
     * @param Season  $season
     */
    public function setSeason(?Season $season): void
    {
        $this->season = $season;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position = null)
    {
        $this->position = $position;
    }

    /**
     * @param \Symfony\Component\Validator\Context\ExecutionContextInterface $context
     * @Assert\Callback()
     */
    public function validate(ExecutionContextInterface $context)
    {
        if (!$this->getImage()) {
            $message = 'Veuillez ajouter une image';
            $context->buildViolation($message)
                    ->atPath("image.file")
                    ->addViolation();
        }
    }
}