<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model;

use CpCreation\VitiCore\Cart\Model\CartItem;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\UuidInterface;
use Ramsey\Uuid\Uuid;

/**
 * Class ProductGift
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Product\Repository\ProductGiftRepository")
 * @ORM\Table(name="product_gift")
 * @ORM\HasLifecycleCallbacks()
 */
class ProductGift
{
    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="string")
     *
     * @var string
     */
    private $token;

    /**
     * @ORM\Column(type="datetime",nullable=true)
     *
     * @var \DateTime | null
     */
    private $usedAt = null;

    /**
     * @ORM\Column(type="datetime",nullable=true)
     *
     * @var \DateTime
     */
    private $validUntilDate = null;

    /**
     * @ORM\ManyToOne(targetEntity="CpCreation\VitiCore\Cart\Model\CartItem",inversedBy="gifts")
     *
     * @var CartItem
     */
    private $cartItem;
    
    public function __construct(){
        $this->token = strtoupper(bin2hex(random_bytes(4)));
        $this->id = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getToken(): string
    {
        return $this->token;
    }

    /**
     * @param string $token
     */
    public function setToken(string $token): void
    {
        $this->token = $token;
    }

    /**
     * @return \DateTime|null
     */
    public function getUsedAt(): ?\DateTime
    {
        return $this->usedAt;
    }

    /**
     * @param \DateTime|null $usedAt
     */
    public function setUsedAt(?\DateTime $usedAt): void
    {
        $this->usedAt = $usedAt;
    }

    /**
     * @return CartItem
     */
    public function getCartItem(): CartItem
    {
        return $this->cartItem;
    }

    /**
     * @param CartItem $cartItem
     */
    public function setCartItem(CartItem $cartItem): void
    {
        $this->cartItem = $cartItem;
    }

    /**
     * @return null|\DateTime
     */
    public function getValidUntilDate(): ?\DateTime
    {
        return $this->validUntilDate;
    }

    /**
     * @param null|\DateTime $validUntilDate
     */
    public function setValidUntilDate(?\DateTime $validUntilDate): void
    {
        $this->validUntilDate = $validUntilDate;
    }
}