<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\News\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * Class NewsTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="news_news_translation")
 */
class NewsTranslation implements TranslationInterface
{
    use Translation;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;
    
    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $title;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $title2;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $text;

    /**
     * @ORM\Column(type="text")
     * @Gedmo\Slug(fields={"title","title2"})
     *
     * @var string
     */
    private $slug;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $moreInfo;

    public function __construct()
    {
        $this->id       = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }
    
    /**
     * @return string
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @param string $title
     */
    public function setTitle(string $title = null): void
    {
        $this->title = $title;
    }

    /**
     * @return string
     */
    public function getTitle2(): ?string
    {
        return $this->title2;
    }

    /**
     * @param string $title2
     */
    public function setTitle2(string $title2 = null)
    {
        if (!$this->title2)
        {
            $this->title2 = $title2;
        }else{
            $this->title2 = "";
        }
    }

    /**
     * @return string
     */
    public function getSlug(): ?string
    {
        return $this->slug;
    }

    /**
     * @param string $slug
     */
    public function setSlug(string $slug = null): void
    {
        $this->slug = $slug;
    }

    /**
     * @return string
     */
    public function getText(): ?string
    {
        return $this->text;
    }

    /**
     * @param string $text
     */
    public function setText(string $text = null): void
    {
        $this->text = $text;
    }

    /**
     * @return string
     */
    public function getMoreInfo(): ?string
    {
        return $this->moreInfo;
    }

    /**
     * @param string $moreInfo
     */
    public function setMoreInfo(string $moreInfo = null): void
    {
        $this->moreInfo = $moreInfo;
    }
}
