<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\Payment;

use CpCreation\VitiCore\Behavior\HasPayment;
use CpCreation\VitiCore\Contact\Model\Contact;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\Routing\RouterInterface;

class AxeptaProvider implements PaymentProviderInterface
{
    const TYPE = 'axepta';

    private $router;

    private $path;

    public function __construct(RouterInterface $router,
        $paths
    ) {
        $this->router = $router;
        foreach ($paths as $path) {
            if ($path['name'] === $this->getMethod()) {
                $this->path = $path['path'];
            }
        }
    }

    /**
     * @param Contact $contact
     * @param HasPayment $payment
     * @return RedirectResponse
     */
    public function checkout(Contact $contact, HasPayment $payment)
    {

        return new RedirectResponse(
            $this->router->generate(
                $this->path, [
                    'id' => $payment->getId()->toString(),
                ]
            )
        );
    }

    /**
     * @return string
     */
    public function getMethod(): string
    {
        return static::TYPE;
    }
}
