<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager;


use CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\SocialNetwork\SocialNetworkProviderInterface;

class SocialNetworkProviderManager
{
    private $providers = [] ;

    /**
     * @param SocialNetworkProviderInterface $provider
     */
    public function addProvider(SocialNetworkProviderInterface $provider)
    {
        $this->providers[] = $provider;
    }

    /**
     * @param $network
     * @param $count
     * @return mixed
     * @throws \Exception
     */
    public function getMedias($network,$count)
    {
        foreach ($this->providers as $item)
        {
            if ($item->getNetwork() === $network){

                return $item->getMedias($count);
            }
        }

        throw new \Exception("Pas de provider de réseau social trouvé");

    }
}
