<?php
/**
 * Created by Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site;

use CpCreation\VitiCore\Payment\Model\Payment;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PaymentType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $builder
            ->add(
                'lastname', TextType::class, [
                    'required' => true,
                    'label'    => 'form.payment.lastname',
                    'attr'     => ['placeholder' => 'form.payment.lastname'],
                ]
            )
            ->add(
                'firstname', TextType::class, [
                    'required' => true,
                    'label'    => 'form.payment.firstname',
                    'attr'     => ['placeholder' => 'form.payment.firstname'],
                ]
            )
            ->add(
                'street', TextType::class, [
                    'required' => true,
                    'label'    => 'form.payment.street',
                    'attr'     => ['placeholder' => 'form.payment.street'],
                ]
            )
            ->add(
                'postalCode', TextType::class, [
                    'required' => true,
                    'label'    => 'form.payment.postal',
                    'attr'     => ['placeholder' => 'form.payment.postal'],
                ]
            )
            ->add(
                'city', TextType::class, [
                    'required' => true,
                    'label'    => 'form.payment.city',
                    'attr'     => ['placeholder' => 'form.payment.city'],
                ]
            )
            ->add(
                'phone', TextType::class, [
                    'required' => true,
                    'label'    => 'form.payment.phone',
                    'attr'     => ['placeholder' => 'form.payment.phone'],
                ]
            )
            ->add(
                'email', EmailType::class, [
                    'required' => true,
                    'label'    => 'form.payment.email',
                    'attr'     => ['placeholder' => 'form.payment.email'],
                ]
            )
            ->add(
                'reference', TextType::class, [
                    'required' => true,
                    'label'    => 'form.payment.order-ref',
                    'attr'     => [
                        'placeholder'  => 'form.payment.order-ref',
                        'autocomplete' => 'off',
                    ],
                ]
            )
            ->add(
                'amount', MoneyType::class, [
                    'divisor'  => 100,
                    'required' => true,
                    'label'    => 'form.payment.amount',
                    'attr'     => [
                        'placeholder'  => 'form.payment.amount',
                        'autocomplete' => 'off',
                    ],
                ]
            )
            ->add(
                'g_recaptcha_response', RecaptchaType::class
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                "data_class" => Payment::class,
            ]
        );
    }
}
