<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\SocialNetwork;

use CpCreation\VitiCore\SocialNetwork\Model\Network\Instagram;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class InstagramNetworkType extends AbstractType implements SocialNetworkNetworkInterface, DataTransformerInterface
{
    const TYPE = 'instagram';

    private $serializer;

    public function __construct()
    {
        $normalizers = [new ObjectNormalizer()];
        $this->serializer = new Serializer($normalizers);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('clientId', TextType::class,[
                'label' => 'Client ID',
                'required'    => true
            ])
            ->add('clientSecret', TextType::class,[
                'label' => 'Client Secret',
                'required'    => true
            ])
        ;

        $builder->addModelTransformer($this);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Instagram::class
        ]);
    }

    public function transform($data)
    {

        return $this->serializer->denormalize($data, Instagram::class);
    }

    public function reverseTransform($data)
    {

        return $this->serializer->normalize($data);
    }

    public function getNetwork()
    {
        return static::TYPE;
    }

    public function getBlockPrefix()
    {
        return 'instagram_network';
    }
}