<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslatedEntityType;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Model\ProductType;
use CpCreation\VitiCore\Product\Model\ProductType as ModelProductType;
use CpCreation\VitiCore\Shop\Model\ShippingZone;
use CpCreation\VitiCore\Shop\Model\ShopConfigMultiple;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ShopConfigMultipleType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('qtyOf', IntegerType::class, ['label' => 'De (>)', 'required' => true])
            ->add('qtyAt', IntegerType::class, ['label' => 'A (<=)', 'required' => true])
            ->add('multiple', IntegerType::class, ['label' => 'Multiple/Minimum autorisé', 'required' => true])
            ->add('minimum', CheckboxType::class, ['label' => 'Minimum au lieu de multiple', 'required' => false])
            ->add(
                'zones', EntityType::class,
                [
                    'class'        => ShippingZone::class,
                    'choice_label' => 'name',
                    'label'        => 'Zone(s)',
                    'multiple'     => true,
                    'required'     => true,
                    'attr'         => [
                        'class' => 'select2',
                    ],
                ]
            )
            ->add(
                'types', TranslatedEntityType::class,
                [
                    'class'                => ModelProductType::class,
                    'translation_property' => 'name',
                    'choice_label'         => function (ProductType $type) {
                        if ($type->getInfo())
                        {
                            return $type->getName().'('.$type->getInfo().')';
                        }else{
                            return $type->getName();
                        }

                    },
                    'label'                => 'Type(s) pris en compte',
                    'multiple'             => true,
                    'required'             => true,
                    'attr'                 => [
                        'class' => 'select2',
                    ],
                ]
            )
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ShopConfigMultiple::class
            ]
        );
    }
}
