<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\DependencyInjection\Compiler;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager\SocialNetworkNetworkManager;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class SocialNetworkNetworkPass implements CompilerPassInterface
{

    public function process(ContainerBuilder $container)
    {
        $definition = $container->findDefinition(SocialNetworkNetworkManager::class);
        $taggedServices = $container->findTaggedServiceIds('viti-core.form.social_network');

        foreach ($taggedServices as $id => $tags) {
            // add the transport service to the TransportChain service
            $definition->addMethodCall('addMethod', [new Reference($id)]);
        }
    }

}