<?php

namespace CpCreation\VitiCore\Bridge\Doctrine\Filter;

use CpCreation\VitiCore\Behavior\HasDisable;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Query\Filter\SQLFilter;

/**
 * @author Colinet Julien
 */
final class DisableFilter extends SQLFilter
{
    /**
     * @param ClassMetadata $targetEntity
     * @param string        $targetTableAlias
     * @return string
     */
    public function addFilterConstraint(ClassMetadata $targetEntity, $targetTableAlias)
    {
        foreach ($targetEntity->getReflectionClass()->getInterfaces() as $interface) {
            if ($interface->getName() === HasDisable::class) {

                return "{$targetTableAlias}.disabled = FALSE";
            }
        }

        return '';
    }
}