<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior\Impl;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Knp\DoctrineBehaviors\Model\Translatable\TranslatableTrait;
use Symfony\Component\Validator\Constraints as Assert;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Validator\Constraints as AcmeAssert;

trait Translatable
{
    use TranslatableTrait;

    /**
     * @Assert\Valid
     * @AcmeAssert\Translation()
     *
     * @var TranslationInterface[]|Collection
     */
    protected $translations;

    /**
     * @return Collection|TranslationInterface[]
     */
    public function getTranslations()
    {
        if ($this->translations === null) {
            $this->translations = new ArrayCollection();
        }

        return $this->translations;
    }

    public function __call($method, $arguments)
    {
        return $this->proxyCurrentLocaleTranslation($method, $arguments);
    }

    public static function getTranslationEntityClass(): string
    {
        $explodedNamespace = explode('\\', __CLASS__);
        $entityClass       = array_pop($explodedNamespace);

        return '\\'.implode('\\', $explodedNamespace).'\\Translation\\'.$entityClass.'Translation';
    }
}
