<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior\Impl;

use Doctrine\ORM\Mapping as ORM;
use CpCreation\VitiCore\Media\Model\Image as ModelImage;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Trait ImageMandatory
 * @package App\Behavior\Impl
 */
trait ImageMandatory
{
    /**
     * @Assert\NotBlank()
     * @Assert\Valid()
     *
     * @ORM\OneToOne(targetEntity="CpCreation\VitiCore\Media\Model\Image", cascade={"persist", "remove"})
     * @ORM\JoinColumn(name="image_id", referencedColumnName="id", onDelete="SET NULL", nullable=true)
     *
     * @var ModelImage
     */
    private $image;

    /**
     * @return ModelImage|null
     */
    public function getImage(): ?ModelImage
    {
        return $this->image;
    }

    /**
     * @param ModelImage $image
     */
    public function setImage(ModelImage $image = null)
    {
        if ($image->getPath() || $image->getFile()) {
            $this->image = $image;
        } else {
            $this->image = null;
        }
    }

}
