<?php

namespace CpCreation\VitiCore\SocialNetwork\Repository;

use CpCreation\VitiCore\Repository\BaseRepository;
use CpCreation\VitiCore\SocialNetwork\Model\SocialNetwork;
use Doctrine\Persistence\ManagerRegistry;

class SocialNetworkRepository extends BaseRepository
{
    /**
     * SocialNetworkRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, SocialNetwork::class);
    }

    /**
     * @param $social
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findByLikeSocial($social)
    {
        $qb = $this->createQueryBuilder('socialNetwork')
                    ->andWhere('socialNetwork.network LIKE :social')
                    ->setParameter('social', '%'.$social.'%')
                    ->orderBy('socialNetwork.createdAt', 'DESC')
                    ->setMaxResults(1);

        return $qb->getQuery()->getOneOrNullResult();

    }
}