<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class DeliveryMethodCategoryTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="shop_delivery_method_category_translation")
 * @ORM\HasLifecycleCallbacks()
 */
class DeliveryMethodCategoryTranslation implements TranslationInterface
{
    use Translation;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;
    
    /**
     * @ORM\Column(type="string")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $name;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $description;

    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @var string | null
     */
    private $minViewTextOpen;

    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @var string | null
     */
    private $minViewTextClose;

    public function __construct()
    {
        $this->id       = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }
    
    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription(string $description = null)
    {
        $this->description = $description;
    }


    /**
     * @return string|null
     */
    public function getMinViewTextOpen(): ?string
    {
        return $this->minViewTextOpen;
    }

    /**
     * @param string|null $minViewTextOpen
     */
    public function setMinViewTextOpen(?string $minViewTextOpen): void
    {
        $this->minViewTextOpen = $minViewTextOpen;
    }

    /**
     * @return string|null
     */
    public function getMinViewTextClose(): ?string
    {
        return $this->minViewTextClose;
    }

    /**
     * @param string|null $minViewTextClose
     */
    public function setMinViewTextClose(?string $minViewTextClose): void
    {
        $this->minViewTextClose = $minViewTextClose;
    }
}
