<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model;


use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Model\ProductType;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ShippingAdditionalManual
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Shop\Repository\ShippingAdditionalManualRepository")
 * @ORM\Table(name="shop_shipping_additional_manual")
 * @ORM\HasLifecycleCallbacks()
 */
class ShippingAdditionalManual implements HasTimestamp
{
    use Timestamp;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="integer")
     * @Assert\NotBlank()
     *
     * @var integer
     */
    private $qtyOf;

    /**
     * @ORM\Column(type="integer")
     * @Assert\NotBlank()
     *
     * @var integer
     */
    private $qtyAt;

    /**
     * @ORM\Column(type="integer")
     *
     * @var integer
     */
    private $dateOf;

    /**
     * @ORM\Column(type="integer")
     *
     * @var integer
     */
    private $dateAt;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int | null
     */
    private $packagePrice = null;

    /**
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int | null
     */
    private $bottlePrice = null;

    /**
     * @ORM\ManyToMany(targetEntity="ShippingZone")
     * @Assert\Count( min = 1 , minMessage="Vous devez ajouter au moins une zone")
     *
     * @var Collection<ShippingZone>
     */
    private $zones;

    /**
     * @ORM\ManyToMany(targetEntity="CpCreation\VitiCore\Product\Model\ProductType", fetch="EAGER")
     * @Assert\Count( min = 1 , minMessage="Vous devez ajouter au moins un type")
     * @var Collection<ProductType>
     */
    private $types;

    /**
     * @ORM\ManyToMany(targetEntity="CpCreation\VitiCore\Product\Model\ProductPriceGroup", fetch="EAGER")
     * @Assert\Count( min = 1 , minMessage="Vous devez ajouter au moins un groupe")
     * @var Collection<ProductPriceGroup>
     */
    private $groups;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $ht = false;

    public function __construct()
    {
        $this->id     = Uuid::uuid4();
        $this->zones  = new ArrayCollection();
        $this->types  = new ArrayCollection();
        $this->groups = new ArrayCollection();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getQtyOf(): ?int
    {
        return $this->qtyOf;
    }

    /**
     * @param int $qtyOf
     */
    public function setQtyOf(int $qtyOf = null)
    {
        $this->qtyOf = $qtyOf;
    }

    /**
     * @return int
     */
    public function getQtyAt(): ?int
    {
        return $this->qtyAt;
    }

    /**
     * @param int $qtyAt
     */
    public function setQtyAt(int $qtyAt = null)
    {
        $this->qtyAt = $qtyAt;
    }

    /**
     * @return int
     */
    public function getDateOf(): ?int
    {
        return $this->dateOf;
    }

    /**
     * @param int $dateOf
     */
    public function setDateOf(int $dateOf = null)
    {
        $this->dateOf = $dateOf;
        //Correspond au 31 décembre
        if (!$dateOf) {
            $this->dateOf = 1231;
        }
    }

    /**
     * @return int
     */
    public function getDateAt(): ?int
    {
        return $this->dateAt;
    }

    /**
     * @param int $dateAt
     */
    public function setDateAt(int $dateAt = null)
    {
        $this->dateAt = $dateAt;
        if (!$dateAt) {
            $this->dateAt = 1231;
        }
    }

    /**
     * @return int | null
     */
    public function getPackagePrice(): ?int
    {
        return $this->packagePrice;
    }

    /**
     * @param int | null $packagePrice
     */
    public function setPackagePrice(?int $packagePrice): void
    {
        $this->packagePrice = $packagePrice;
    }

    /**
     * @return int | null
     */
    public function getBottlePrice(): ?int
    {
        return $this->bottlePrice;
    }

    /**
     * @param int | null $bottlePrice
     */
    public function setBottlePrice(?int $bottlePrice): void
    {
        $this->bottlePrice = $bottlePrice;
    }

    /**
     * @return Collection
     */
    public function getZones(): Collection
    {
        return $this->zones;
    }

    /**
     * @param Collection $zones
     */
    public function setZones(Collection $zones): void
    {
        $this->zones = $zones;
    }

    /**
     * @return Collection
     */
    public function getTypes(): Collection
    {
        return $this->types;
    }

    /**
     * @param Collection $types
     */
    public function setTypes(Collection $types): void
    {
        $this->types = $types;
    }

    /**
     * @return ArrayCollection|Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * @param ArrayCollection|Collection $groups
     */
    public function setGroups($groups): void
    {
        $this->groups = $groups;
    }

    /**
     * @return bool
     */
    public function isHt(): bool
    {
        return $this->ht;
    }

    /**
     * @param bool $ht
     */
    public function setHt(bool $ht): void
    {
        $this->ht = $ht;
    }
}
